#include <iostream>

#include "iic/Bus.h"
#include "iic/Base.h"
#include "iic/TempSensor.h"

int main() {
		
	//IICBus bus("/dev/i2c-0", 0); // Interface type native iic
	//IICBus bus("/dev/iowarrior", 1, "00001FEC"); // Interface type iowarrior iic
	IICBus bus("/dev/iowarrior",1,"000023DD");	
	IICTempSensor sensor(bus,0x4f, "Temperatursensor",0,1); // 9 Bit, TOUT active high 

	bus.autodetect();
	bus.init();
	
	sensor.setThermostat(200, 300); // 20C and 30C

	sensor.startConvert();
	sleep(1); // give sensor some time to convert first temperature

	int temp;
	while(1) {
	
		temp = sensor.readTemp();
		printf("Aktuelle Temperatur: %d.%d Celsius\n", temp / 10, temp % 10);
		sleep(1);
	}
		
	return 0;
}

