// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#include <iostream>

#include "iic/Bus.h"
#include "iic/Base.h"
#include "iic/TempSensor.h"
#include "iic/Multiplexer.h"

int main() {
	 	
	IICBus bus("/dev/i2c-0", 0); // Interface type native iic
	//IICBus bus("/dev/iowarrior", 1, "00001FEC"); // Interface type iowarrior iic

	IICMultiplexer node_1(bus, 0x30, "Node Room 1", 4);
	IICMultiplexer node_2(bus, 0x31, "Node Room 2", 4);

	IICTempSensor sensor1(bus,0x4f, "Temperatursensor 1",0,1); // 9 Bit, TOUT active high 

	IICTempSensor sensor2(bus,0x4f, "Temperatursensor 2",0,1); // 9 Bit, TOUT active high 
	bus.makeSubModule(sensor2,node_1,0);
	IICTempSensor sensor3(bus,0x4f, "Temperatursensor 3",0,1); // 9 Bit, TOUT active high 
	bus.makeSubModule(sensor3,node_1,1);
	IICTempSensor sensor4(bus,0x4f, "Temperatursensor 4",0,1); // 9 Bit, TOUT active high 
	bus.makeSubModule(sensor4,node_2,0);
	IICTempSensor sensor5(bus,0x4f, "Temperatursensor 5",0,1); // 9 Bit, TOUT active high 
	bus.makeSubModule(sensor5,node_2,1);

	bus.autodetect();
	bus.init();

	sensor1.setThermostat(200, 300); // 20°C and 30°C
	sensor1.startConvert();
	sensor2.setThermostat(200, 300); // 20°C and 30°C
	sensor2.startConvert();
	sensor3.setThermostat(200, 300); // 20°C and 30°C
	sensor3.startConvert();
	sensor4.setThermostat(200, 300); // 20°C and 30°C
	sensor4.startConvert();
	sensor5.setThermostat(200, 300); // 20°C and 30°C
	sensor5.startConvert();

	sleep(1); // give sensors some time to convert first temperature

	int temp[5];
	while(1) {
	
		temp[0] = sensor1.readTemp();
		temp[1] = sensor2.readTemp();
		temp[2] = sensor3.readTemp();
		temp[3] = sensor4.readTemp();
		temp[4] = sensor5.readTemp();

		printf("Aktuelle Temperaturen: \n");
		for (int i = 0; i < 5; i++) {
			printf("Sensor %d: %d.%d Celsius\n", i, temp[i] / 10, temp[i] % 10);
		}
		sleep(1);
	}
		
	return 0;
}


