// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  helloworld.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      15.09.2008
// *****************************************************************

#include <linux/version.h>	/* Linux Version */
#include <linux/module.h>	/* Makros and Defines */
#include <linux/moduleparam.h> /* Module Parameters */

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Joachim Schroeder");
MODULE_DESCRIPTION("Command line Argument Example");

static int arg1 = -1;
static char* arg2 = "isempty";
static short arg3[2] = {0,0};
static int count = 0;
static int i;

module_param(arg1, int,0);
MODULE_PARM_DESC(arg1, "is a int");
module_param(arg2, charp,0);
MODULE_PARM_DESC(arg2, "is a string");
module_param_array(arg3, short, &count, 0);
MODULE_PARM_DESC(arg3, "is a short-array");

int commandline_init(void) {
	printk(KERN_INFO "Module commandline: init()\n");
	printk(KERN_INFO "arg1 is of type int: %d\n", arg1);
	printk(KERN_INFO "arg2 is of type char*: %s\n", arg2);
	printk(KERN_INFO "arg3 is of type short array and contains: %d elements\n", count);
	for (i=0; i<count; i++) {
		printk(KERN_INFO "arg3[%d] = %d\n", i, arg3[i]);
	}
	return 0;
}

void commandline_exit(void) {
	printk(KERN_INFO "Module commandline: exit()\n");
}

module_init(commandline_init);
module_exit(commandline_exit);


