// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      29.09.2008
// *****************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "../file_operations/ioctldefs.h"

char buf[MAXMSGLEN];

void printbuf(int num) {
	
	int i = 0;
	printf("---Device Buffer: ");
	for (i=0; i<num; i++) printf("%c",buf[i]);
	printf("\n");
}

int main() {
	
	int fd;
	fd = open("/dev/myfirstdevice", O_RDWR);
	if (fd < 0) {
		printf("Error opening device, fd = %d\n",fd);
		exit(0);
	}
	
	// test read(), write()
	int num = read(fd, buf, MAXMSGLEN);
	printbuf(num);
	
	sprintf(buf, "Greetings from User-Space\n");
	printf("Writing to device: %s\n", buf);
	write(fd, buf, sizeof(buf));
	num = read(fd, buf, MAXMSGLEN);
	printbuf(num);
	
	// test IOctls
	printf("Setting standard message via ioctl()\n");
	ioctl(fd, IOCTL_SETSTDMSG, 0);
	num = read(fd, buf, MAXMSGLEN);
	printbuf(num);
	
	printf("Clearing device buffer via ioctl()\n");
	ioctl(fd, IOCTL_CLRMSGBUF, 0);
	num = read(fd, buf, MAXMSGLEN);
	printbuf(num);
	
	close(fd);
	return 0;
}

