// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  helloworld.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      15.09.2008
// *****************************************************************

#include <linux/version.h>	/* Linux Version */
#include <linux/module.h>	/* Makros and Defines */
#include <linux/fs.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Joachim Schroeder");
MODULE_DESCRIPTION("Module Registration Argument Example");

static struct file_operations fops;

int modulereg_init(void) {
	printk(KERN_INFO "Module modulereg: init()\n");

   if( register_chrdev(60,"myfirstdriver",&fops)==0 ) {
        return 0;
    }
    return -EIO;
}

void modulereg_exit(void) {
	printk(KERN_INFO "Module modulereg: exit()\n");
	unregister_chrdev(60,"myfirstdriver");
}

module_init(modulereg_init);
module_exit(modulereg_exit);


