



/*

http://www.linux.it/~rubini/docs/serial/serial.html
http://www.lafn.org/~dave/linux/Serial-Programming-HOWTO.txt
http://www.beyondlogic.org/serial/serial.htm
http://www.beyondlogic.org/serial/termpoll.c

gut! http://kerneltrap.org/mailarchive/linux-kernel/2007/5/24/95146/thread

*/

#include <linux/version.h>	/* Linux Version */
#include <linux/module.h>	/* Makros and Defines */
#include <linux/fs.h>
#include <asm/uaccess.h>	/* put_user() */
#include <linux/cdev.h>
#include <linux/tty.h>
#include <asm/io.h>
#include <linux/ioport.h>

#include "ioctldefs.h"

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Joachim Schroeder");
MODULE_DESCRIPTION("File Operations Example");

/* Prototypes */
int fops_init(void);
void fops_exit(void);
static ssize_t fops_read(struct file *, char *, size_t, loff_t *);
static ssize_t fops_write(struct file *, const char *, size_t, loff_t *);
static int fops_open(struct inode *, struct file *);
static int fops_close(struct inode *, struct file *);
static int fops_ioctl( struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg );
void set_state(void);
static int serial_request(void);
static int serial_init(void);
void serial_release(void);

/* Global Variables */
static char rel_state = 0x00;
static int is_open = 0;
/*static char msg[MAXMSGLEN];
static char* p_msg;
static int msg_len = 0;
*/
static struct cdev *driver_info = NULL;
static struct file_operations fops = {
	.owner		= 	THIS_MODULE,
	.read		=	fops_read,
	.write		=	fops_write,
	.ioctl		= 	fops_ioctl,
	.open		=	fops_open,
	.release	=	fops_close
};

int fops_init(void) {
	printk(KERN_INFO "Module relaiscard: init()\n");

	// allocate device number
    if( register_chrdev_region( MKDEV(MAJORNUM,0), NUMDEVICES, DEVNAME ) ) {
        pr_debug("Device number 0x%x not available ...\n", MKDEV(MAJORNUM,0));
        return -EIO;
    }

	// allocate device
	driver_info = cdev_alloc();
    if( driver_info == NULL ) {
        pr_debug("cdev_alloc failed!\n");
        goto free_devnum;
    }

	// specify device structure (init) and register (add)
    kobject_set_name(&driver_info->kobj, DEVNAME );
    driver_info->owner = THIS_MODULE;
    cdev_init( driver_info, &fops );
    if( cdev_add( driver_info, MKDEV(MAJORNUM,0), NUMDEVICES) ) {
        pr_debug("cdev_add failed!\n");
        goto free_cdev;
    }
	/*
	if( serial_request() < 0) {
	    pr_debug("init_request failed!\n");
        goto free_cdev;	
	}
*/
	// init serial connection
    if( serial_init() < 0 ) {
        pr_debug("init_serial failed!\n");
        goto free_cdev;
    }
    return 0;

free_cdev:
    kobject_put(&driver_info->kobj);
    driver_info = NULL;	
free_devnum:
	unregister_chrdev_region(MKDEV(MAJORNUM,0), NUMDEVICES);
	return -1;
}

void fops_exit(void) {
	printk(KERN_INFO "Module relaiscard: exit()\n");
	
	serial_release();
	
	// remove char device from system
	if( driver_info ) cdev_del( driver_info );
    
	// free device number
	unregister_chrdev_region(MKDEV(MAJORNUM,0), NUMDEVICES);
}

module_init(fops_init);
module_exit(fops_exit);

/* FOPS Functions */
static int fops_open(struct inode* inode, struct file* file){
	
	if (is_open) return -EBUSY;
	
	is_open++;
	try_module_get(THIS_MODULE);
	pr_debug("Module fops: device %s was opened from device with minor no %d\n", DEVNAME, iminor(inode));
	return 0;
}

static int fops_close(struct inode* inode, struct file* file){
		
	is_open--;
	module_put(THIS_MODULE);
	pr_debug("Module fops: device %s was closed\n", DEVNAME);
	return 0;
}

static ssize_t fops_read(struct file* file, char* buf, size_t len, loff_t* offset) {
	
	int num = 0;
	/*if (*msg == 0) {
		pr_debug("Module fops: Msg buffer is empty!\n");
		return 0;
	}
	
	if (msg_len - (p_msg - msg) < len) {
		len = msg_len - (p_msg - msg);
		pr_debug("Module fops: not enough content, can read only %d bytes\n", len);		
		
	}

	num = len - copy_to_user(buf, p_msg, len);
	p_msg += num;
	pr_debug("Module fops: sent %d bytes to user space\n", num);
*/
	return num;
}

static ssize_t fops_write(struct file* file, const char* buf, size_t len, loff_t* offset){
	
	int num = 0;
	/*if (len > MAXMSGLEN) {
		pr_debug("Module fops: Msg buffer is too small, skipping %d bytes!\n", len - MAXMSGLEN);
		len = MAXMSGLEN;
	}
	
	num = len - copy_from_user(msg, buf, len);
	msg_len = num;
	pr_debug("Module fops: received %d bytes from user space\n", num);
	*/	
	return num;
}



static int fops_ioctl( struct inode *inode, struct file *file,
       unsigned int cmd, unsigned long arg )
{
	
	switch( cmd ) {       
	case IOCTL_ENABLE_ALL:
  		pr_debug("Module relaiscard: Switching all relais ON\n");
		rel_state = 0xFF;
		set_state();
		break;                              
    case IOCTL_DISABLE_ALL:
  		pr_debug("Module relaiscard: Switching all relais OFF\n");
		rel_state = 0x00;
		set_state();
		break;
    case IOCTL_SET_ALL:
  		pr_debug("Module relaiscard: Setting relais state to 0x%0x\n", (char) arg);
		rel_state = (char) arg;
		set_state();
       break;
    case IOCTL_GET_STATUS:
  		pr_debug("Module relaiscard: Relais state is 0x%0x\n", rel_state);
		*((char*)arg) = rel_state;
		break;
    default:
       pr_debug("unknown IOCTL 0x%x\n", cmd);
       return -EINVAL;
    }
    return 0;
}

static int serial_request() {
	
	int res;
	struct resource *res_p;
	if (check_region(SERPORT , 8 ) < 0){
		printk(KERN_ALERT "serial: can't get I/O address SERPORT\n");
		return -1;
	}
	else
		res_p = request_region(SERPORT,8,"serial");
	if(res_p == NULL)
		printk("<0>allocation not possible\n");
	else
		printk("<0>allocation possible\n");	
		
	return 0;
}


static int serial_init() {

  // Defines Serial Ports Base Address 
  // COM1 SERPORT                        
  // COM2 0x2F8			       
  // COM3 0x3E8			       
  // COM4 0x2E8			       

 int c;
 int ch;
 outb(0, SERPORT + 1);   // Turn off interrupts - SERPORT

 //         PORT 1 - Communication Settings       

 outb(0x80, SERPORT + 3);  // SET DLAB ON 
 outb(0x0c, SERPORT + 0);  // Set Baud rate - Divisor Latch Low Byte 
			      // 		 0x03 =  38,400 BPS 
			      //         0x01 = 115,200 BPS 
			      //         0x02 =  57,600 BPS 
			      //         0x06 =  19,200 BPS 
			      //         0x0C =   9,600 BPS 
			      //         0x18 =   4,800 BPS 
			      //         0x30 =   2,400 BPS 
 outb(0x00, SERPORT + 1);  // Set Baud rate - Divisor Latch High Byte 
 outb(0x03, SERPORT + 3);  // 8 Bits, No Parity, 1 Stop Bit 
 outb(0xc7, SERPORT + 2);  // FIFO Control Register 
 outb(0x0B, SERPORT + 4);  // Turn on DTR, RTS, and OUT2 

 //printf("\nSample Comm's Program. Press ESC to quit \n");
 
 outb('h', SERPORT); // Send Char to Serial Port 
 outb('u', SERPORT); // Send Char to Serial Port 
 outb('h', SERPORT); // Send Char to Serial Port 
 outb('u', SERPORT); // Send Char to Serial Port 
 outb('\0', SERPORT); // Send Char to Serial Port 

		return 0;
}


/* Serial Helper Functions */

#ifdef NIX
static int serial_init() {

	 struct file *filp = filp_open("/dev/ttyS0",O_RDWR | O_NDELAY,0);
	 char buf[4096];
	 mm_segment_t oldfs = get_fs();
	 loff_t pos = 0;
	
	 set_ds(KERNEL_DS);
	 while (vfs_read(filp, buf, sizeof(buf), &pos) > 0)
	 	printk("%s\n", buf);
	
	 filp_close(filp);
	
	/*
	struct file *f;
	mm_segment_t oldfs;
	struct tty_struct *tty;
	struct termios term;
	unsigned char buffer[255]; 


	// filp_open(devpriv->serial_device, O_RDWR | O_NOCTTY | O_NDELAY, 0); besser?
	f=filp_open("/dev/ttyS0",O_RDWR | O_NDELAY,0);
	oldfs=getfs();
	set_fs(KERNEL_DS);
	f->f_pos=0;
	tty=(struct tty_struct*)f->private_data;

	tty->termios->c_flag=B9600 | CRTSCTS | CS8 | CLOCAL | CREAD;
	tty->termios->c_flag&=~(PARENB | PARODD);
	tty->termios->c_flag&=~CRTSCTS;
	tty->termios->c_iflag= IGNBRK;

	tty->termios->c_oflag=0;
	tty->termios->c_lflag=0;
	tty->termios->c_cc[VTIME]=0;
	tty->termios->c_cc[VMIN]=10;

	f->f_op->read(f,buffer,10,&f->f_pos); 
*/	
	return 0;
}
#endif

void set_state(){

}

void serial_release() {
	release_region(SERPORT,8);
}












