// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      30.10.2008
// *****************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "../relaiscard/ioctldefs.h"


int main(int argc, char *argv[]) {
	
	int fd;
	char ch;
	
	if (argc != 2) {   // Test for correct number of arguments
		printf("Usage: %s <relais device>\n", argv[0]);
 		exit(1);
	}
	
	fd = open(argv[1], O_RDWR);
	if (fd < 0) {
		printf("Error opening device, fd = %d\n",fd);
		exit(0);
	}
	
	int i;
	for (i=0; i<10; i++) {
		ch = '1';
		write(fd,&ch,1);
		sleep(1);

		ch = '0';
		write(fd,&ch,1);
		sleep(1);
	}
	close(fd);
}
	
