// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  ControlPanel.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      03.11.2008
// *****************************************************************

#include <QPushButton>
#include <QLCDNumber>
#include <QGridLayout>
#include <QApplication>
#include <QLabel>
#include <iostream>
#include "ControlPanel.h"

ControlPanel::ControlPanel(char *argv [], QWidget *parent)
	: QWidget(parent)
{
	client_address = QHostAddress(argv[1]);
	client_port = atoi(argv[2]);
	server_port = atoi(argv[3]);
	
	QPushButton *button_quit = new QPushButton("Quit");
	QPushButton *button_send = new QPushButton("Send");
	QLabel *currpos_label = new QLabel("Current Position");	
	QLCDNumber *lcd_currpos = new QLCDNumber();
	QLabel *targetpos_label = new QLabel("Target Position");	
	QLCDNumber *lcd_targetpos = new QLCDNumber();

	slider = new QSlider();
	slider->setOrientation(Qt::Horizontal);
	bar = new QProgressBar();

	QGridLayout *layout = new QGridLayout();
	layout->addWidget(button_quit,1,0);
	layout->addWidget(button_send,3,0);
	layout->addWidget(currpos_label,0,1);
	layout->addWidget(targetpos_label,2,1);
	layout->addWidget(bar,1,1);
	layout->addWidget(slider,3,1);
	layout->addWidget(lcd_currpos,1,5);
	layout->addWidget(lcd_targetpos,3,5);

	setLayout(layout);
	
	udpSocketSend = new QUdpSocket(this);
	udpSocketReceive = new QUdpSocket(this);
	udpSocketReceive->bind(server_port);
  
	connect(button_quit, SIGNAL(clicked()), qApp, SLOT(quit()));
	connect(button_send, SIGNAL(clicked()), this, SLOT(broadcastDatagram()));
	connect(udpSocketReceive, SIGNAL(readyRead()), this, SLOT(processPendingDatagrams()));
	connect(slider, SIGNAL(valueChanged(int)), lcd_targetpos, SLOT(display(int)));
	connect(bar, SIGNAL(valueChanged(int)), lcd_currpos, SLOT(display(int)));
}

void ControlPanel::broadcastDatagram() {
 		
 	control_data.data.target_pos = slider->value();
	control_data.incCount();
	control_data.hton();
	udpSocketSend->writeDatagram(control_data.getData(), control_data.getSize(), client_address, client_port);
	control_data.ntoh();                         
	std::cout << "Send Target Value " << control_data.data.target_pos << std::endl;
}

void ControlPanel::processPendingDatagrams()
{
	while (udpSocketReceive->hasPendingDatagrams()) {

		udpSocketReceive->readDatagram(mes_data.getData(), mes_data.getSize());
		mes_data.ntoh();
		std::cout << "Received message no " << mes_data.getCount() << " with current value " << mes_data.data.current_pos << std::endl;
		bar->setValue(mes_data.data.current_pos);     
	}
}
 
 
 
 
 
 
 
 
