// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  ControlPanel.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      03.11.2008
// *****************************************************************

#ifndef _CONTROL_PANEL_H_
#define _CONTROL_PANEL_H_

#include <QWidget>
#include <QSlider>
#include <QProgressBar>
#include <QUdpSocket>
#include "Datagrams.h"

class ControlPanel : public QWidget
{
	Q_OBJECT

public:
	ControlPanel(char *argv [], QWidget *parent = 0);

public slots:
	
private:
	QUdpSocket *udpSocketSend;
	QUdpSocket *udpSocketReceive;
	QHostAddress client_address;
	quint16 client_port;
	quint16 server_port;
	
	bool dataChanged;
	DatagramControl control_data;
	DatagramMeasure mes_data;
	QSlider *slider;
	QProgressBar *bar;

private slots:
	void broadcastDatagram();
	void processPendingDatagrams();
};

#endif /* _CONTROL_PANEL_H_ */


