// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  ControlPanel.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      04.11.2008
// *****************************************************************

#ifndef _CONTROLPANEL_H_
#define _CONTROLPANEL_H_

#include <QWidget>
#include <QUdpSocket>
#include "Datagrams.h"
#include "iic/Stepper.h"
#include "ui_ControlPanel.h"

class ControlPanel : public QWidget, private Ui::Panel
{
	Q_OBJECT

public:
	ControlPanel(char *argv [], QWidget *parent = 0);
	virtual ~ControlPanel();

public slots:
	
signals:
	
private:

	QUdpSocket *udpSocketSend;
	QUdpSocket *udpSocketReceive;
	QHostAddress client_address;
	quint16 client_port;
	quint16 server_port;
	QTimer *timer;
	
	bool dataChanged;
	DatagramControl control_data;
	DatagramMeasure mes_data;
	DatagramParam param_data;
	int num_mesg_rec, num_mesg_send;

private slots:
	void broadcastDatagramParam();
	void broadcastDatagramControl();
	void sendNewTargetpos();
	void sendGotoRefpos();
 	void processPendingDatagrams();
	void noConn();
};

#endif /* _CONTROLPANEL_H_ */

