// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Datagrams.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      04.11.2008
// *****************************************************************

#ifndef _DATAGRAMS_H_
#define _DATAGRAMS_H_

#include "iic/Stepper.h"
#include "tools/AbstractDatagram.h"


enum EDatagramId {
	MEASURE,
	CONTROL,
	PARAM,
};

typedef struct {
	u_int16_t actual_pos;
	motor_status status;
} measure_data_t;

class DatagramMeasure : public AbstractDatagram {

public:
	DatagramMeasure() : AbstractDatagram() {
		initDatagram(&header, sizeof(header) + sizeof(data), MEASURE);
	}
	virtual ~DatagramMeasure(){}

	virtual void htonData(){
		// implement data conversion here
		data.actual_pos = htons(data.actual_pos);
		// no need to convert motor status (no 16 or 32 Bit ints)
	}
	virtual void ntohData(){
		// implement data conversion here
		data.actual_pos = ntohs(data.actual_pos);
		// no need to convert motor status (no 16 or 32 Bit ints)
	}

	// keep these together!
	datagram_header_t header;
	measure_data_t data;
};


typedef struct {
	u_int8_t goto_ref_pos;
	u_int8_t new_target_pos;
	u_int16_t target_pos;
} control_data_t;

class DatagramControl : public AbstractDatagram {

public:
	DatagramControl() : AbstractDatagram() {
		initDatagram(&header, sizeof(header) + sizeof(data), CONTROL);
	}
	virtual ~DatagramControl(){}

	virtual void htonData(){
		// implement data conversion here
		data.target_pos = htons(data.target_pos);
	}
	virtual void ntohData(){
		// implement data conversion here
		data.target_pos = ntohs(data.target_pos);
	}

	// keep these together!
	datagram_header_t header;
	control_data_t data;

};

typedef struct {
	motor_params param;
	u_int8_t new_data;
} param_data_t;

class DatagramParam : public AbstractDatagram {

public:
	DatagramParam() : AbstractDatagram() {
		initDatagram(&header, sizeof(header) + sizeof(data), PARAM);
	}
	virtual ~DatagramParam(){}

	virtual void htonData(){
		// implement data conversion here
		// no need to convert motor params (no 16 or 32 Bit ints)
	}
	virtual void ntohData(){
		// implement data conversion here
		// no need to convert motor params (no 16 or 32 Bit ints)
	}

	// keep these together!
	datagram_header_t header;
	param_data_t data;

};

#endif /* _DATAGRAMS_H_ */





