// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Receiver.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#include <sys/types.h>			// Primitive system data types
#include <stdio.h>				// Input/Output
#include <stdlib.h>				// General utilities
#include <string.h>				// String handling
#include <sys/socket.h>			// Basic socket functions
#include <netdb.h> 				// Translating protocol and host names
#include <arpa/inet.h>			// Internet address manipulation

int main(int argc, char *argv[]) {

	struct addrinfo cfg,*srv;
	struct sockaddr_in client_addr;
	socklen_t addrlen = sizeof(client_addr);
	int fd, recvlen;
	char buf[100];
	char host[20];
	char service[6];

	if (argc != 2) {   // Test for correct number of arguments
		printf("Usage: %s <Receive Port>\n", argv[0]);
		exit(1);
	}

	printf ("Receiving UDP-packets at port %s..\n", argv[1]);
	// make sure defaults are 0/NULL
	memset ( &cfg, 0, sizeof(struct addrinfo) );
	cfg.ai_flags = AI_PASSIVE;
	cfg.ai_family = PF_INET;
	cfg.ai_socktype = SOCK_DGRAM;
	cfg.ai_protocol = IPPROTO_UDP;
	if (getaddrinfo ( NULL, argv[1], &cfg, &srv) != 0) {
		printf("Error resolving address or service\n");
		exit(1);
	}
	fd = socket ( srv->ai_addr->sa_family, srv->ai_socktype, srv->ai_protocol);
	if (bind ( fd, srv->ai_addr, srv->ai_addrlen) != 0) {
		printf("Error resolving address or service\n");
		exit(1);
	}
	while(1) {
		recvlen = recvfrom(fd, &buf, 100, 0, (struct sockaddr *) &client_addr, (socklen_t *) &addrlen );
		printf("Received string: %s from %s:%d\n", buf, inet_ntoa(client_addr.sin_addr), ntohs(client_addr.sin_port) );
	}
	return 0;
}
