// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Sender.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#include <sys/types.h>			// Primitive system data types
#include <stdio.h>				// Input/Output
#include <stdlib.h>				// General utilities
#include <string.h>				// String handling
#include <sys/socket.h>			// Basic socket functions
#include <netdb.h> 				// Translating proocol and host names

int main(int argc, char *argv[]) {

	struct addrinfo cfg,*srv;
	int fd, buflen;
	char buf[100];

	if (argc != 3) {   			// Test for correct number of arguments
		printf("Usage: %s <Send IP> <Send Port>\n", argv[0]);
		exit(1);
	}

	printf ("Sending UDP-packets to %s:%s..\n", argv[1], argv[2]);
	// make sure that defaults are 0/NULL
	memset ( &cfg, 0, sizeof(struct addrinfo) );
	cfg.ai_family = PF_INET;
	cfg.ai_socktype = SOCK_DGRAM;
	cfg.ai_protocol = IPPROTO_UDP;
	if (getaddrinfo ( argv[1], argv[2], &cfg, &srv) != 0) {
		printf("Error resolving address\n");
		exit(1);
	}
	fd = socket ( srv->ai_addr->sa_family, srv->ai_socktype, srv->ai_protocol);

	while(1) {
		printf("Enter your string now, ENTER to send\n");
		// read characters and send them
		scanf("%s", buf);
		buflen = strlen(buf) + 1;
		if ( sendto ( fd, &buf, buflen, 0, srv -> ai_addr, srv -> ai_addrlen) != buflen) printf("Error sending string\n");
	}
	return 0;
}


