// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Receiver.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      03.11.2008
// *****************************************************************

#include "tools/PracticalSocket.h" 			// UDPSocket and SocketException
#include <iostream>          				// cout and cerr
#include <cstdlib>           				// atoi()

#include "../udp_cpp_sender/Datagrams.h"

using namespace std;

const int ECHOMAX = 255;     				// Longest string to echo

int main(int argc, char *argv[]) {

	if (argc != 2) {			// Test for correct number of arguments
		cout << "Usage: " << argv[0] << " <Server Port>" << endl;
		exit(1);
	}

	DatagramMeasure mes;
	unsigned short echoServPort = atoi(argv[1]);		// Local port
	string sourceAddress;             					// Source address
	unsigned short sourcePort;        					// Source port

	UDPSocket sock(echoServPort);

	while (1) {
		sock.recvFrom(&mes, sourceAddress, sourcePort);

		cout << "Received packet from " << sourceAddress << ":"
		     << sourcePort << " no " << mes.getCount() << endl;
		cout << "Value 1: " << mes.data.value1 << endl;
		cout << "Value 2: " << mes.data.value2 << endl;
		cout << "Value 3: " << mes.data.value3 << endl << endl;
	}
	return 0;
}
