// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Datagrams.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#ifndef _DATAGRAMS_H_
#define _DATAGRAMS_H_

#include <linux/types.h>
#include "tools/AbstractDatagram.h"

enum eDatagram {
	MEASURE
};

class DatagramMeasure : public AbstractDatagram {

private:
	typedef struct {
		u_int16_t value1;	// some sample values
		u_int32_t value2;
		char value3[20];
	} __attribute__ ((packed)) measure_data_t;

public:
	DatagramMeasure() : AbstractDatagram() {
		initDatagram(&header, sizeof(header) + sizeof(data), MEASURE);
	}
	virtual ~DatagramMeasure(){}

	virtual void htonData(){
		// implement data conversion here
		data.value1 = htons(data.value1);
		data.value2 = htonl(data.value2);
	}
	virtual void ntohData(){
		// implement data conversion here
		data.value1 = ntohs(data.value1);
		data.value2 = ntohl(data.value2);
	}

	// keep these together!
	datagram_header_t header;
	measure_data_t data;
};

#endif /* _DATAGRAMS_H_ */




