// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Sender.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      03.11.2008
// *****************************************************************

#include "tools/PracticalSocket.h"	// UDPSocket and SocketException
#include <iostream>					// cout and cerr
#include <cstring>					// strcpy()
#include <cstdlib>					// atoi()

#include "Datagrams.h"

using namespace std;

const int ECHOMAX = 255;          		// Longest string to echo

int main(int argc, char *argv[]) {

	if (argc != 3) {   					// Test for correct number of arguments
		cout << "Usage: " << argv[0] << " <Server> <Server Port>\n";
		exit(1);
	}

	DatagramMeasure mes;
	mes.data.value1 = 0;
	mes.data.value2 = 0;
	strcpy(mes.data.value3, "Nachricht");

	string serv_address = argv[1]; 				// server address
	unsigned short serv_port = atoi(argv[2]);	// server port

	UDPSocket sock;

	while(1) {

		// Send string to server
		sock.sendTo(&mes, serv_address, serv_port);
		cout << "Sending message no " << mes.getCount() << endl;

		mes.data.value1 = mes.getCount() % 2;
		mes.data.value2 = mes.getCount() % 10;
		sleep(1);
	}
	return 0;
}

