// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  ServoThread.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Daniel Jagszent
// Date:      26.04.2008
// *****************************************************************


#ifndef SERVOTHREAD_H_
#define SERVOTHREAD_H_

#include "tools/PeriodicThread.h"
#include "tools/Mutex.h"
#include "tools/WaitCondition.h"

class ServoThread: public PeriodicThread {
public:
	typedef long long measurment_t;
	enum { NUM_MEASUREMENTS = 1000 };

	ServoThread();
	virtual ~ServoThread();

	void start_stats();
	measurment_t* get_stats();

	void set_servo_position(int newPosition);

	int get_servo_position();

protected:
	virtual void do_turn();
	int m_i;
	long long m_servo_position;
	measurment_t m_measurements1[NUM_MEASUREMENTS];
	measurment_t m_measurements2[NUM_MEASUREMENTS];
	measurment_t* m_measurements;
	int m_measurements_index;
	Mutex m_stats_mutex;
	WaitCondition m_stats_finished;
	long long m_last_period_start;
};

#endif /* SERVOTHREAD_H_ */
