// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  io.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Daniel Jagszent
// Date:      26.04.2008
// *****************************************************************


#include "io.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "vsopenrisc.h"
#include <iostream>
#include <iomanip>
#include <sys/io.h>

int fd = -1;

const int PARPORT_ADDRESS = 0x378;

void io_deinit() {
#ifdef PARPORT
	if (ioperm(PARPORT_ADDRESS, 3, 0)) {
		perror("io_deinit: could not close parallel port");
		exit(1);
	}
#endif

	if (fd >= 0) {
		close(fd);
	}
}

void io_init() {

#ifdef PARPORT
	if (ioperm(PARPORT_ADDRESS, 3, 1)) {
		perror("io_init: could not open parallel port. Are you root?");
		exit(1);
	}
#endif

#ifdef VSOPENRISC_IO
	fd = open("/dev/gpio", O_RDWR);
	if (fd < 0) {
		perror("io_init: could not open /dev/gpio");
		exit(1);
	}

	gpio_struct cmd_val;
	cmd_val.mask = 255;
	cmd_val.value = 255;
	if (ioctl(fd, GPIO_CMD_SET_CTRL, &cmd_val) == -1) {
		perror("io_init: ioctl: GPIO_CMD_SET_CTRL");
		exit(1);
	}
#endif

	atexit(io_deinit);
}

void io_set_high() {

#ifdef PARPORT
	outb(0x01,PARPORT_ADDRESS);
#endif

#ifdef VSOPENRISC_IO
	gpio_struct val;
	val.mask = 255;
	val.value = 255;
	if (ioctl(fd, GPIO_CMD_SET, &val) == -1) {
		perror("io_set_high: ioctl: GPIO_CMD_SET");
		exit(1);
	}
#endif
}

void io_set_low() {

#ifdef PARPORT
	outb(0x00,PARPORT_ADDRESS);
#endif

#ifdef VSOPENRISC_IO
	gpio_struct val;
	val.mask = 255;
	val.value = 0;
	if (ioctl(fd, GPIO_CMD_SET, &val) == -1) {
		perror("io_set_low: ioctl: GPIO_CMD_SET");
		exit(1);
	}
#endif
}
