// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Daniel Jagszent
// Date:      26.04.2008
// *****************************************************************

#include <iostream>
#include <time.h>
#include <sys/mman.h> // mlockall

#include "ServoThread.h"
#include "UiThread.h"
#include "DisplayThread.h"
#include "tools/timing_functions.h"
#include "io.h"


int main(int argc, char **argv)
{
  using namespace std;
  try {

    // make all our memory sticky
    mlockall(MCL_CURRENT|MCL_FUTURE);

    // "-r" renices the program to real-time priority
    if (argc == 2 && ::strcmp(argv[1], "-r")==0) {
      Thread::setTaskPrio(Thread::PRIO_HIGH);
      cout << "Task priority set to REALTIME" << endl;
    }

    timespec res;
    clock_getres(CLOCK_REALTIME, &res);
    cout << "CLOCK_REALTIME resolution = " << getNanoseconds(res) << "ns" << endl;

    io_init();

#ifdef USE_IIC
    //IICBus bus("/dev/i2c-0",0);
    IICBus* m_bus = new IICBus("/dev/iowarrior",1,"000023DD");

    IICDisplay* m_display = new IICDisplay(*m_bus,0x27, "Display Nr. 1", SIZE_4x20);

    m_bus->init();
#endif

    ServoThread io;
    UiThread ui(&io);
#ifdef USE_IIC
    DisplayThread iic(m_display, io);
#endif
    io.start(Thread::PRIO_HIGH);
    ui.start(Thread::PRIO_LOW);
#ifdef USE_IIC
    iic.start(Thread::PRIO_LOW);
#endif
    ui.wait(); // UI terminates when io terminated
#ifdef USE_IIC
    iic.wait();
#endif

    return 0;
  } catch (exception& e) {
    cerr << "Got exception in main method: " << e.what() << endl;
    return 1;
  }
}
