// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Daniel Jagszent
// Date:      27.04.2008
// *****************************************************************

#include <pthread.h>
#include <stdio.h>

pthread_mutex_t mutex;
pthread_cond_t cond;
char condition=0;

void *thread1_function(void *val_p) {
	for(;;) {
		pthread_mutex_lock(&mutex);
		while (!condition) {
			pthread_cond_wait(&cond, &mutex);
		}
		printf("Read value %d \n", *((int*)val_p));
		sleep(1);
		condition = 0;
		pthread_mutex_unlock(&mutex);
	}
}
void *thread2_function(void *val_p) {
	for(;;) {
		sleep(1);
		pthread_mutex_lock(&mutex);
		++(*((int*)val_p));
		printf("Incrementing value, is now %d \n", *((int*)val_p));
		condition = 1;
		pthread_cond_broadcast(&cond);
		pthread_mutex_unlock(&mutex);
	}
}

int main() {
	pthread_t th1, th2;
	int value = 4;

	pthread_mutex_init(&mutex, NULL);
	pthread_cond_init(&cond, NULL);

	printf("Exit Program with Ctrl+C\nInitial value is %d\n", value);

	pthread_create(&th1, NULL, thread1_function, &value);
	pthread_create(&th2, NULL, thread2_function, &value);

	pthread_join(th1, NULL);
	pthread_join(th2, NULL);

	pthread_cond_destroy(&cond);
	pthread_mutex_destroy(&mutex);

	return 0;

}





