// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      26.04.2008
// *****************************************************************

#include "tools/Thread.h"
#include "tools/Mutex.h"
#include <iostream>
#include <string.h>

class MyThread: public Thread {

public:
	MyThread(string s, int& c, Mutex& m) :
		s(s), count(c), count_mutex(m) {
	}

	virtual void run() {

		int times = 0;

		while (times < 10) {
			count_mutex.lock();
			++count;
			std::cout << s << " " << count << std::endl;
			count_mutex.unlock();
			sleep(1);
			++times;
		}
	}
private:

	string s;
	int& count;
	Mutex& count_mutex;

};

int main() {

	int count = 0;
	Mutex count_mutex;

	MyThread m1("Hallo", count, count_mutex);
	MyThread m2("Welt", count, count_mutex);

	m1.start();
	m2.start();
	sleep(1);

	while (m1.isRunning() && m2.isRunning()) {
		{
			MutexLocker m(count_mutex);
			count++;
			std::cout << "main(): Counter is now " << count << std::endl;
		}
		sleep(1);
	}

	m1.wait();
	m2.wait();
	return 0;

}

