// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#include <iostream>
#include <linux/input.h>
#include "tools/SerialPort.h"
#include "tools/RelaisBoard.h"

using namespace std;

int main(int argc, char *argv[]) {

	if (argc != 3) {																		// check number of parameters
		printf("Usage: %s <input_event> <serial_device> \n",argv[0]);
		return -1;	
	}

	char ch;	
	unsigned char relais_state = 0x00;

	SerialPort Serial(argv[2], 19200, 0, 8, 1, true);									// devicename, baudrate, parity, data bits, stopbits
	RelaisBoard Relais(Serial);
	relais_state = Relais.getStatus();
	printf("Relais status is %d\n",relais_state);

	int fd = open(argv[1], O_RDWR | O_NOCTTY); // use blocking open

	if (fd == -1) {
		printf("Unable to open %s\n",argv[1]);
		return -1;
	}

	struct input_event ev;

	cout << "Press key (1..8) to switch relais, 'e' to quit" << endl;

	while(1) {

	read(fd,&ev,sizeof(struct input_event));

		if (ev.type == EV_KEY && ev.value == 1) {
			if (ev.code == 18) break;
			ch = ev.code - 1;
			if (ch < 1 || ch > 8) continue; // only accept input of keys 1..8
//			printf("You typed value: 0x%02x\n",ch);

			relais_state ^= (1<<(ch-1));
			Relais.setRelaisOn(relais_state);
			Relais.setRelaisOff(~relais_state);

			printf("Switching to relais state 0x%02x\n",relais_state);
		}
	}
	return 0;
}

