// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  GPSReceiver.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      12.07.2008
// *****************************************************************

#ifndef _GPSRECEIVER_H_
#define _GPSRECEIVER_H_

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <cmath>

#ifdef  __cplusplus
extern "C" {
#endif // __cplusplus

#include "gpsd-2.37/gpsd_config.h"
#include "gpsd-2.37/gpsd.h"
#include "gpsd-2.37/timebase.h"

#ifdef  __cplusplus
}
#endif // __cplusplus

class GPSReceiver {

	public:
		GPSReceiver(char*);
		~GPSReceiver();
		int updateData();
		int printData();		// prints out 
		int getSatellites();
		double getSpeed();	// returns current speed
		double getTime();		// returns received time
		double getUTMX();		// returns x-coordinate in UTM
		double getUTMY();		// returns y-coordinate in UTM
		double getAltitude();
		
		static const double deg2rad;
		static const double a;
		static const double eccSquared;
		static const double k0;

	private:
		void LLtoUTM(const double Lat, const double Long,\
			double &UTMNorthing, double &UTMEasting, char* UTMZone);
		char UTMLetterDesignator(double Lat);
		struct gps_device_t session;	// gpsd session
		struct gps_context_t context;	// gpsd context
		
		int used_satellites;	// number of used satellites
		int satellites;			// number of available satellites
		double latitude;		// latitude coordinate [degs]
		double longitude;		// longitude coordinate [degs]
		double altitude;		// altitude [m]
		double speed;			// speed [km/h]
		double time;			// timestamp [s]
		double utm_x;			// UTM x coordinate [m]
		double utm_y;			// UTM y coordinate [m]
};

#endif /* _GPSRECEIVER_H_ */

