// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      05.10.2008
// *****************************************************************

#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <linux/input.h>	/* struct input_event */

int main(int argc, char *argv[]) {

	if (argc != 2) {
		printf("Usage: %s <device> \n", argv[0]);
		return -1;
	}

	int fd = open(argv[1], O_RDWR | O_NOCTTY); // use blocking open

	if (fd == -1) {
		printf("Unable to open %s\n",argv[1]);
		return -1;
	}

	struct input_event ev;
	char ch;

	while(1) {
		read(fd,&ev,sizeof(struct input_event));

		if (ev.type == EV_KEY && ev.value == 1) {
			printf("Event: time %ld.%06ld, type %d, code %d, value %d\n",
			       ev.time.tv_sec, ev.time.tv_usec, ev.type,
			       ev.code, ev.value);
		}
	}
	close(fd);
	return 0;
}


