// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  DAConverter.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      25.07.2008
// *****************************************************************

#ifndef _ADCONVERTER_H_
#define _ADCONVERTER_H_

#include <map>
#include "iic/Base.h"

#define MAXCH 4

enum eDAConverterMode {
	SINGLE_ENDED_INPUT,	//!< four single ended inputs
	THREE_DIFF_INPUTS,	//!< three differential inputs
	SINGLE_DIFF_MIXED,	//!< single ended and differential mixed
	TWO_DIFF_INPUTS		//!< two differential inputs
};

//! This class represents iic-components of type PCF8591.
class IICADConverter : public IICBase {

public:
	IICADConverter(IICBus& bus, int addr, const std::string& name, eDAConverterMode); //!< for eDAConverterMode see header file
	~IICADConverter(){};

	int setAutoInc(bool autoinc);	//!< set autoinc flag

	//! Read data register value. read_immediate=1 reads up-to-date-value, table_num reads real value (-1) or converted value using table table_num.
	int readChannel(int channel, bool read_immediate, int table_num);

	int setChannel(int channel);     //!< set input channel for voltage measuring [0,1,2,3]

	int setOutput(int value);        //!< sets A/D output value (0..255), -1 to disable

	//! Add value pair v1,v2 to table which is used for channel. v1 is register value, v2 function value.
	void setScoreTable(int v1, int v2, int channel);

	//! Returns function value from score table for a given register value and channel number.
	int getScoreTable(int value, int channel);

protected:
	void init();

private:
	char m_control_byte;						//!< control byte
	int m_channel;								//!< current AD-channel
	int m_mode;									//!< AD input mode
	bool m_autoinc;								//!< autoincrement flag
	std::map<int,int> scoreTable[MAXCH];		//!< score table for sensor charact.
};

#endif /* _ADCONVERTER_H_ */

