
#include "iic/Bus.h"
#include "iic/Base.h"

using namespace std;

IICBase::IICBase(IICBus& bus, int addr, const std::string& name) :
		m_bus(bus),
		m_addr(addr),
		m_name(name),
		m_is_removable(0),
		m_err_count(0)
{

		setStatus(true);
		m_id = bus.addModule(m_addr, this);
}


IICBase::~IICBase(){

	m_bus.rmModule(m_id);
}

void IICBase::setStatus(bool status) {
	m_status = status;
	if (status)
		m_err_count = 0;
}

int IICBase::writeData(char* buf, int num) {

	if (m_status) {

		int res = m_bus.iicWrite(m_id, buf, num);

		if ((res != num) && !m_is_removable ){
			printf("Error writing to address 0x%0x\n", m_addr);
			printf("res %d, num %d\n", res, num);
			m_err_count++;
		}

		// too many errors, disable device
		if (m_err_count >= MAXERR) {
			printf("Total of %d errors when accessing address 0x%0x, disabling device\n", m_err_count, m_addr);
			m_status = false;
		}
		return res;
	}
	return 0;
}

int IICBase::readData(char* buf, int num) {

	if (m_status) {
		int res = m_bus.iicRead(m_id, buf, num);
		if ((res != num) && !m_is_removable ){
			printf("Error reading from address 0x%0x\n", m_addr);
			printf("res %d, num %d\n", res, num);
			m_err_count++;
		}
		// too many errors, disable device
		if (m_err_count >= MAXERR) {
			printf("Total of %d errors when accessing address 0x%0x, disabling device\n", m_err_count, m_addr);
			m_status = false;
		}

		return res;
	}
	return 0;
}

