// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  ChipCard.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Stephan Riedel
// Date:      26.04.2008
// *****************************************************************

#ifndef _CHIPCARD_H_
#define _CHIPCARD_H_

#include "iic/Base.h"
#include "tools/AES.h"

#define PAGESIZE 64
#define CHIPCARDSIZE 16384
#define TYPEID "1827454954"

//! This class represents iic-chipcards of type AT24Cxx.
class IICChipCard : public IICBase {

struct ChipcardHeader_t {
	char type_id[10+1];		//!< id for cards of this type
	char card_number[10+1];	//!< individual card number
	char descr[30+1];		//!< description
};

public:
	IICChipCard(IICBus& bus, int addr, const std::string& name);                //!< IICBUS, address iic bus, name, pointer to data, size of data
	virtual ~IICChipCard(){};
	int readSCHeader();                                             //!< read content of header
	void printSCHeader();                                           //!< read content of header
	int formatSCHeader(const char* card_number, const char* descr); //!< write a new header
	int readSCData(char* dest, unsigned long size);                 //!< read data from chipcard
	int writeSCData(char* source, unsigned long size);              //!< write data to chipcard
	bool isAvailable();                                             //!< check if chipcard is available

protected:
	void init(){};

private:
	void setToAddress(unsigned int address);  //!< internal memory pointer needs to be set to address before writing
	ChipcardHeader_t m_Header;                //!< header object
};

#endif /* _CHIPCARD_H_ */

