// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  IOExpander.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      23.07.2008
// *****************************************************************

#include "iic/IOExpander.h"

using namespace std;

IICIOExpander::IICIOExpander(IICBus& bus, int addr, const string& name) : IICBase(bus,addr,name) {
	m_state = 0x00;
	m_buf[0] = 0x00;
}

int IICIOExpander::setPort(char data) {
	m_state = data;
	return writeData(&m_state,1);
}

int IICIOExpander::setPortOn(char pins) {
	m_state |= pins;
	return writeData(&m_state,1);
}

int IICIOExpander::setPortOff(char pins) {
	m_state &= ~pins;
	return writeData(&m_state,1);
}

int IICIOExpander::getPort() {
	if (readData(m_buf,1) != 1) return -1;
	else return *m_buf &= 0x00FF;
}

int IICIOExpander::getPin(char pin) {
	if (readData(m_buf,1) != 1) return -1;
	else return ((*m_buf >> pin) % 2);
}

