// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  IOExpander.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      23.07.2008
// *****************************************************************

#ifndef _IOEXPANDER_H_
#define _IOEXPANDER_H_

#include "iic/Base.h"

//! This class represents iic-components of type PCF8574 for general purpose.
class IICIOExpander : public IICBase {

public:
	IICIOExpander(IICBus& bus, int addr, const std::string& name);
	~IICIOExpander(){};
	int setPort(char data);			//!< set entire port to value data
	int setPortOn(char pins);		//!< set pin(s) high indicated by data
	int setPortOff(char pins);		//!< set pin(s) low indicated by data
	int getPort();					//!< get entire port status
	int getPin(char pin);			//!< read the state of a single pin (0..7)

protected:
	void init(){};

private:
	char m_buf[1];						// read/write buffer
	char m_state;
};

#endif /* _IOEXPANDER_H_ */


