// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Keyboard.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      26.04.2008
// *****************************************************************

#include "iic/Keyboard.h"

using namespace std;

IICKeyboard::IICKeyboard(IICBus& bus, int addr, const string& name) : IICBase(bus,addr, name) {

	m_key_val = 0;
	m_key_val_old = 0;
}


IICKeyboard::~IICKeyboard() {

}

/**************************************************************
Init function to set table
**************************************************************/
void IICKeyboard::init() {

	// load keymap
	m_keymap.insert( make_pair(17, '1') );
	m_keymap.insert( make_pair(33, '2') );
	m_keymap.insert( make_pair(65, '3') );
	m_keymap.insert( make_pair(129, '4') );
	m_keymap.insert( make_pair(18, '5') );
	m_keymap.insert( make_pair(34, '6') );
	m_keymap.insert( make_pair(66, '7') );
	m_keymap.insert( make_pair(130, '8') );
	m_keymap.insert( make_pair(20, '9') );
	m_keymap.insert( make_pair(36, '0') );
	m_keymap.insert( make_pair(68, 'c') );
	m_keymap.insert( make_pair(132, 'e') );
	m_keymap.insert( make_pair(24, 'C') );
	m_keymap.insert( make_pair(40, 'D') );
	m_keymap.insert( make_pair(72, 'A') );
	m_keymap.insert( make_pair(136, 'B') );


	m_buf = 0x00;
	writeData(&m_buf,1);
}

/**************************************************************
Function to read a character from the keyboard; needs polling,
sends on push only
**************************************************************/
char IICKeyboard::getKey() {

	map<unsigned char, unsigned char>::iterator iter;

	do {

		m_key_val_old = m_key_val;

		// read column
		m_buf = 0x0F;
		writeData(&m_buf,1);	// High level on P0..P3
		readData(&m_buf,1);
		m_key_val = 0x0F & ~m_buf;		// determine column value {16,32,46,128}

		// read row
		m_buf = 0xF0;
		writeData(&m_buf,1);	// High level on P4..P7
		readData(&m_buf,1);
		m_key_val += 0xF0 & ~m_buf;	// add row value {1,2,4,8}

		iter = m_keymap.find(m_key_val);

		usleep(POLL_CYCLE);
	} while ( iter == m_keymap.end() || m_key_val == m_key_val_old );

	if (iter == m_keymap.end()) return -1;
	else return iter->second;

}


