// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Keyboard.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      26.04.2008
// *****************************************************************

#ifndef _KEYBOARD_H_
#define _KEYBOARD_H_

#include <iostream>
#include <map>

#include "iic/Base.h"

const long POLL_CYCLE = 200000;

//! This class represents iic matrix keyboards, that are driven by a PCF8574 iic port expander.
class IICKeyboard : public IICBase
{

public:
	IICKeyboard(IICBus& bus, int addr, const std::string& name);
	virtual ~IICKeyboard();

	//! Gets a char from the keyboard. Non-blocking, returns -1 when no key is pressed.
	char getKey();

protected:
	void init();

private:
	char m_buf;                                      //!< r/w buffer
	unsigned char m_key_val, m_key_val_old;          //!< curr and prev key values
	std::map<unsigned char, unsigned char> m_keymap; //!< value-char pairs
};

#endif /* _KEYBOARD_H_ */

