// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Multiplexer.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      28.04.2008
// *****************************************************************

#include "iic/Base.h"
#include "iic/Bus.h"
#include "iic/Multiplexer.h"

using namespace std;

IICMultiplexer::IICMultiplexer(IICBus& bus, int addr, const string& name, int max_channel) : IICBase(bus, addr, name), m_max_channel(max_channel), m_channel(-1) {

	m_channel = -1;		// channel is off per default
	char buf = 0x00;		// disable channels
	writeData(&buf,1);
}

int IICMultiplexer::setChannel(int channel) {

	char buf;

	if (channel == m_channel) return 0;
	if (channel < -1 || channel >= m_max_channel) return -1;

	if (channel == -1) {
		buf = 0x00;
	}
	else {
		buf = 1 << channel;
	}
	if (writeData(&buf,1) == 1){
		m_channel = channel;
	}
	return m_channel;

}

int IICMultiplexer::getCurrChannel() {

	char buf;
	if (readData(&buf,1) < 0) return -1;

	return buf;
}

