// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Multiplexer.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      28.04.2008
// *****************************************************************

#ifndef _MULTIPLEXER_H_
#define _MULTIPLEXER_H_

class IICBase; // forward declaration

//! A multiplexer module for extending an IICBus so that it supports more iic modules of the same type.
class IICMultiplexer : public IICBase
{

public:
	IICMultiplexer(IICBus& bus, int addr, const std::string& name, int max_channel);
	virtual ~IICMultiplexer(){};
	//! Returns the maximum number of channels.
	int getMaxChannel() const { return m_max_channel; }
	//! Returns the current multiplexer channel.
	int getCurrChannel();
	//! sets the multiplexer channel to ch (0..max_channel-1)
	int setChannel(int ch);

protected:
	void init(){};

private:
	int m_max_channel;
	int m_channel;
};

#endif /* _MULTIPLEXER_H_ */

