// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  TempSensor.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      26.04.2008
// *****************************************************************

#ifndef _TEMPSENSOR_H_
#define _TEMPSENSOR_H_

#include <iostream>

#include "iic/Base.h"

//! //! This class represents iic temperature sensors of type DS1631.
class IICTempSensor : public IICBase
{

public:
	IICTempSensor(IICBus& bus, int addr, const std::string& name, char res, bool t_out_pol);
	virtual ~IICTempSensor(){};

	//! Start continuous conversion.
	int startConvert();
	//! Stop continuous conversion.
	int stopConvert();
	int setThermostat(int t_low, int t_high); //!< values are in °C * 10
	//! Reset both low and high temperature flags.
	int resetTempFlags();
	//! Returns the current temperature in °C * 10. In case of error, return value is -999.
	int readTemp();
	//! Returns either low temperature flag (highlow=false) or high temperature flag (highlow=true).
	bool getTempFlag(bool highlow);

protected:
	void init();

private:
	char m_buf[3];		//!< rw-buffer
	char m_conf_reg;	//!< configuration register
	char m_res;			//!< resolution as 2-bit-value
	bool m_pol;			//!< thermostat output polarity
};

#endif /* _TEMPSENSOR_H_ */
