/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <linux/types.h>
#include "iowarrior.h"

#define USB_VENDOR_ID_CODEMERCS	1984
/* low speed iowarrior */
#define USB_DEVICE_ID_CODEMERCS_IOW40	0x1500
#define USB_DEVICE_ID_CODEMERCS_IOW24	0x1501
#define USB_DEVICE_ID_CODEMERCS_IOWPV1	0x1511
#define USB_DEVICE_ID_CODEMERCS_IOWPV2	0x1512
/* full speed iowarrior */
#define USB_DEVICE_ID_CODEMERCS_IOW56	0x1503

int main (int argc, char **argv) {
    struct iowarrior_info info;
    int fd = -1;
    int result=-1;
    int i;
    int ports=0;	//the number depends on the product
    fd_set wrfds;	/* the write-set for select */
    fd_set rfds;	/* the read-set for select */
    struct timeval tv;	/* the timeout for select */	
    unsigned char buffer[64];


    if(( fd = open( "/dev/usb/iowarrior1", O_RDWR)) < 0 )
    {
	printf( "iowarrior open failed %d\n",errno );
	exit( 1 );
    }
    /* lets see what product we have */
    if( ioctl( fd, IOW_GETINFO, &info)) {
	perror( "Unable to retrieve device info" );
	goto exit;
    }
    /* print the device information */
    printf("The device attached to /dev/usb/iowarrior1\n");
    printf("VendorId=%04x\n",info.vendor);
    printf("ProductId=%04x ",info.product);
    if(info.product==USB_DEVICE_ID_CODEMERCS_IOW40) {
	ports=4;
	printf("(IOWarrior40)\n");
    }
    else if(info.product==USB_DEVICE_ID_CODEMERCS_IOW24) {
	ports=2;
	printf("(IOWarrior24)\n");
    }
    else if(info.product==USB_DEVICE_ID_CODEMERCS_IOW56) {
	ports=7;
	printf("(IOWarrior56)\n");
    }
    else
	printf("(Ooops, unknown device!)\n");
    printf("Serial=0x%s\nRevision=0x%04x\n",info.serial, info.revision); 
    printf("Speed=");
    if(info.speed==1)
	printf("Low Speed (USB 1.1)\n");
    else if(info.speed==2)
	printf("Full Speed (USB 1.1)\n");
    else if(info.speed==3)
	printf("High Speed (USB 2.0)\n");
    else
	printf("Ooops, speed is unknown!\n");
    printf("Power=%dmA\nPacketSize=%d\n",info.power, info.report_size); 
    /* checking for the special-mode interface */
    if(info.if_num!=1) {
	printf("Opps, this is not the SpecialModes interface\n");
	printf("Can't go on\n");
	goto exit;
    }    
    /* writing SpecialMode : GetCurrentPinStatus */
    tv.tv_sec=10;	//we use a timeout of 10 seconds  
    tv.tv_usec=0; 
    FD_ZERO(&wrfds);	//clear the read-descriptors for select 
    FD_SET(fd, &wrfds);	 
    result=select(fd+1,NULL,&wrfds,NULL,&tv); 
    if(result==-1) { 
 	//error in select 
 	perror("Error in select"); 
	goto exit;
    } 
    else if(result==0) { 
 	//select returned 0, no new data to be read 
 	printf("Timeout expired without any data written\n"); 
	goto exit;
    } 
    else { 
 	if(FD_ISSET(fd,&wrfds)) { 
 	    //We got here, so we there should be able to write the data 
	    /* Send a request for Pin-Status */
	    memset(&buffer,0,sizeof(buffer));
	    buffer[0] = 0xFF;		/* Report ID $FF for Pin-Status */
	    result=write(fd,buffer,info.report_size);
 	    if(result!=info.report_size) { 
 		//well thats not what we expected... 
 		int errcode=errno; 
 		if(errcode==ENODEV) {
 		    printf("Device was unplugged\n"); 
		    goto exit;
		}
 		else {
 		    perror("Error in writing!"); 
		    goto exit;
		}
 	    } 
 	    else { 
		printf("Write OK\n"); 
 	    } 
 	} 
    } 
    /* Now wait for the reply from the IOWarrior */
    while(1) {
    tv.tv_sec=10;	//we use a timeout of 10 seconds  
    tv.tv_usec=0; 
    FD_ZERO(&rfds);	//clear the read-descriptors for select 
    FD_SET(fd,&rfds);	 
    result=select(fd+1,&rfds,NULL,NULL,&tv); 
    if(result==-1) { 
 	//error in select 
 	perror("Error in select"); 
	goto exit;
    } 
    else if(result==0) { 
 	//select returned 0, no new data to be read 
 	printf("Timeout expired without any data read\n"); 
	goto exit;
    } 
    else { 
 	if(FD_ISSET(fd,&rfds)) { 
	    memset(&buffer,0,sizeof(buffer));
	    //We got here, so there should be new data available
	    result = read(fd,buffer,info.report_size);
	    if(result!=info.report_size) {
		//well thats not what we expected...
		int errcode=errno;
		if(errcode==ENODEV) 
		    printf("Device was unplugged\n");
		else
		    perror("Error in reading!");
		goto exit;
	    }
	    else {
		//buffer now contains the io-status
		printf("IO-Status: (ReportID=0x%02x) size=%d\n",buffer[0],result);
		for(i=0;i<ports;i++)
		    printf( "Port%d=0x%x\n",i,buffer[i+1]);
		printf("IO-Status: (ReportID=%d)\n",buffer[0]);
		for(i=0;i<ports;i++)
		    printf( "Port%d=%d\n",i,buffer[i+1]);

	    }
	}
    }
    }
    exit :
    close( fd );
    exit(0);
}
