/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <asm/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/types.h>
#include "iowarrior.h"

#define USB_VENDOR_ID_CODEMERCS	1984
/* low speed iowarrior */
#define USB_DEVICE_ID_CODEMERCS_IOW40	0x1500
#define USB_DEVICE_ID_CODEMERCS_IOW24	0x1501
#define USB_DEVICE_ID_CODEMERCS_IOWPV1	0x1511
#define USB_DEVICE_ID_CODEMERCS_IOWPV2	0x1512
/* full speed iowarrior */
#define USB_DEVICE_ID_CODEMERCS_IOW56	0x1503


int main (int argc, char **argv) {
    struct iowarrior_info info;
    int fd = -1;
    int result=-1;
    int i;
    int ports=0;	//the number of depends on the product
    
    unsigned char buffer[64];
    memset(&buffer,0,sizeof(buffer));
    if(( fd = open( "/dev/usb/iowarrior0", O_RDWR)) < 0 )
    {
	perror( "iowarrior open failed" );
	goto exit;
    }
    /* lets see what product we have */
    if( ioctl( fd, IOW_GETINFO, &info)) {
        perror( "Unable to retrieve device info" );
	goto exit;
    }
    /* print the device information */
    printf("The device attached to /dev/usb/iowarrior0\n");
    printf("VendorId=%04x\n",info.vendor);
    printf("ProductId=%04x ",info.product);
    if(info.product==USB_DEVICE_ID_CODEMERCS_IOW40) {
	ports=4;
	printf("(IOWarrior40)\n");
    }
    else if(info.product==USB_DEVICE_ID_CODEMERCS_IOW24) {
	ports=2;
	printf("(IOWarrior24)\n");
    }
    else if(info.product==USB_DEVICE_ID_CODEMERCS_IOW56) {
	ports=7;
	printf("(IOWarrior56)\n");
    }
    else
	printf("(Ooops, unknown device!)\n");
    printf("Serial=0x%s\nRevision=0x%04x\n",info.serial, info.revision); 
    printf("Speed=");
    if(info.speed==1)
	printf("Low Speed (USB 1.1)\n");
    else if(info.speed==2)
	printf("Full Speed (USB 1.1)\n");
    else if(info.speed==3)
	printf("High Speed (USB 2.0)\n");
    else
	printf("Ooops, speed is unknown!\n");
    printf("Power=%dmA\nPacketSize=%d\n",info.power, info.report_size); 
    //read the io-status with USB_GET__REPORT
    result = ioctl(fd,IOW_READ,buffer);
    if(result) {
	//well thats not what we expected...
	int errcode=errno;
	if(errcode==ENODEV) 
	    printf("Device was unplugged\n");
	else
	    perror("Error in reading!");
	goto exit;
    }
    else {
	//buffer now contains the io-status
	printf("IO-Status direct \n");
	for(i=0;i<ports;i++)
	    printf( "Port%d=0x%x\n",i,buffer[i]);
    }
    //close again
 exit:
    close( fd );
    exit( 0 );
}
