// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  AbstractDatagram.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      03.11.2008
// *****************************************************************

#include "AbstractDatagram.h"
#include <iostream>

bool AbstractDatagram::isLE = false;

AbstractDatagram::AbstractDatagram() {
	isLE = checkLittleEndian();	// conversion to BE Network format is only necessary if host format is LE
}

AbstractDatagram::~AbstractDatagram(){}

void AbstractDatagram::initDatagram(datagram_header_t* h, u_int16_t s, int id) {
	header_p = h;
	header_p->size = s;
	msg_size = s;
	header_p->count = 0;
	header_p->id = id;
	header_p->has_network_format = false;
}

bool AbstractDatagram::checkLittleEndian() {
	return ( htons(1) != 1 );
}

u_int16_t AbstractDatagram::getSize() const {
	if (header_p->has_network_format)
		return ntohs(header_p->size);
	else
		return header_p->size;
}

void AbstractDatagram::ntoh(){
	if ( hasNetworkFormat() && isLE ) {
		// conversion for header
		ntohHeader(header_p);

		// conversion for data
		ntohData();
		header_p->has_network_format = false;
	}
}

void AbstractDatagram::hton(){
	if ( !hasNetworkFormat() && isLE ) {
		// conversion for header
		htonHeader(header_p);

		// conversion for data
		htonData();
		header_p->has_network_format = true;
	}
}

void AbstractDatagram::ntohHeader(datagram_header_t* h) {
	h->id    = ntohs(h->id);
	h->size  = ntohs(h->size);
	h->count = ntohl(h->count);
}

void AbstractDatagram::htonHeader(datagram_header_t* h) {
	h->id    = htons(h->id);
	h->size  = htons(h->size);
	h->count = htonl(h->count);
}

