// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  FileHandler.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      08.08.2008
// *****************************************************************

#include "FileHandler.h"

#include <stdio.h>
#include <stdlib.h>

#include <fstream>
#include <iostream>

using namespace std;

FileHandler::FileHandler() {

}

FileHandler::~FileHandler() {

	delete[] m_pBuffer;
}

void FileHandler::readFile(const char* fname) {

	ifstream ifile;
	ifile.open(fname,ios::binary);

	//test if file is open
	if(ifile.is_open()) {
		// get size of file
		ifile.seekg(0, ios::end);
		m_input_size = ifile.tellg();
		ifile.seekg(0, ios::beg);

		// allocate memory
		m_pBuffer = new char [m_input_size];

		// read data as a block
		ifile.read(m_pBuffer,m_input_size);

		// close file pointer
		ifile.close();
	}
	else {
		printf("Error opening file \"%s\"\n",fname);
		exit (0);
	}
}

void FileHandler::writeFile(char* data, int size, const char* fname) {

	m_output_size = size;

	ofstream ofile;
	ofile.open(fname,ios::binary);
	if(ofile.is_open()) {

		// write file
		ofile.write(data,size);

		// close file pointer
		ofile.close();
	}
	else {
		printf("Error opening file \"%s\"\n",fname);
		exit (0);
	}
}

void FileHandler::attachToFile(char* data, int size, int offset, const char* fname) {

	ofstream ofile;
	ofile.open(fname,ios::binary);
	if(ofile.is_open()) {
		// set data pointer
		int pos;
		pos=ofile.tellp();
		ofile.seekp(pos+offset);
		ofile.write(data,size);
		ofile.close();
	}
	else {
		printf("Error opening file \"%s\"\n",fname);
		exit (0);
	}
}

void FileHandler::readFromPos(const char* fname, int offset) {

	ifstream ifile;
	ifile.open(fname,ios::binary);

	//test if file is open
	if(ifile.is_open()) {
		// get size of file
		ifile.seekg(0, ios::end);
		m_input_size = ifile.tellg();
		ifile.seekg(0, ios::beg);

		ifile.seekg(offset);

		// allocate memory
		m_pDataBuffer = new char [m_input_size-offset];

		// read data as a block
		ifile.read(m_pDataBuffer,m_input_size-offset);

		// close file pointer
		ifile.close();
	}
	else {
		printf("Error opening file \"%s\"\n",fname);
		exit (0);
	}
}

void FileHandler::readHeader(const char* fname, int size) {

	ifstream ifile;
	ifile.open(fname,ios::binary);

	//test if file is open
	if(ifile.is_open()) {

		ifile.seekg(0, ios::end);
		ifile.tellg();
		ifile.seekg(0, ios::beg);

		// allocate memory
		m_pHeaderBuffer = new char [size];

		// read data as a block
		ifile.read(m_pHeaderBuffer,size);

		// close file pointer
		ifile.close();
	}
	else {
		printf("Error opening file \"%s\"\n",fname);
		exit (0);
	}
}

