// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  FileHandler.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      08.08.2008
// *****************************************************************

#ifndef _FILEHANDLER_H_
#define _FILEHANDLER_H_

//! Helper class for reading and writing data to files.
class FileHandler {
	public:
		FileHandler();
		~FileHandler();
		void readFile(const char* fname);
		void writeFile(char* data, int size, const char* fname);
		void attachToFile(char* data, int size, int offset, const char* fname);
		void readFromPos(const char* fname, int offset);
		void readHeader(const char* fname, int size);
		int m_input_size;
		int m_output_size;
		char* m_pBuffer;
		char* m_pDataBuffer;
		char* m_pHeaderBuffer;
};

#endif /* _FILEHANDLER_H_ */

