// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Mutex.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      26.04.2008
// *****************************************************************

#include "ParamFile.h"

using namespace std;


ParamFile::ParamFile( string file) : file(file) {
	data.clear();
}

void ParamFile::makeEntry(string name, string value){
	// need to overwrite existing entry
	data_iter = data.find(name);
	if (  data_iter != data.end() ) data_iter->second = value; //data.erase(data_iter);
	else data.insert( make_pair(name,value) );
}

string ParamFile::getValue(string name){
	data_iter = data.find(name);
	if (  data_iter != data.end() ) return data_iter->second;
	else return "";
}

int ParamFile::getSize() const {
	return data.size();
}

int ParamFile::write() {
	ofstream f;
	f.open(file.c_str(), ios::trunc);
	if ( !f.is_open() ) return -1; // file does not exist

	for( data_iter = data.begin(); data_iter != data.end(); data_iter++ ) {
		f << data_iter->first << " " << data_iter->second << endl;
	}
	f.close();
}

int ParamFile::read() {
	data.clear();
	ifstream f;
	f.open(file.c_str(), ios::in);
	if ( !f.is_open() ) return -1; // file does not exist

	string line;
	int line_count = 0;
	size_t pos_start;
	size_t pos_end;
	while (!f.eof()) { // step through lines
		line_count++;
		getline(f, line);
		line.erase( min (line.find_first_of("#"), line.size())); // erase all comments

		pos_start = min(line.find_first_not_of(" "), line.size());
		pos_end = min(line.find_first_of(" ",pos_start), line.size());
		string name = line.substr(pos_start, pos_end - pos_start);

		pos_start = min(line.find_first_not_of(" ",pos_end), line.size());
		pos_end = min(line.find_first_of(" ",pos_start), line.size());
		string value = line.substr(pos_start, pos_end - pos_start);

		if ( name.size() == 0 || value.size() == 0) {

			// Throw error msg only if first entry exists, but no second
			if ( name.size() != 0 && value.size() == 0) {
				cout << "Error parsing file " << file << " in line " << line_count << ". No value?"<< endl;
			}
			continue;
		}
		makeEntry(name, value);
		/*
			cout << line << endl;
			cout << name << "," << value << endl;
		 */
		//cout << pos_start_name << "," << pos_end_name << "/" << pos_start_value << "," << pos_end_value << endl;

	}
	f.close();
	return 0;
}

void ParamFile::print() {
	cout << "Parameters :" << endl;
	map<string,string>::iterator iter;
	for( iter = data.begin(); iter != data.end(); iter++ ) {
		cout << iter->first << " " << iter->second << endl;
	}
}

void ParamFile::clear() {
	data.clear();
}
