// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  Mutex.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      26.04.2008
// *****************************************************************

#include <fstream>
#include <map>
#include <iostream>


//! Reading and writing values from a simple configuration file.
class ParamFile {
public:
	//! Constructor gets the filename of the configuration file.
	ParamFile( std::string file);
	//! Introduces a new name value pair. To persist this change, you have to call write afterwards.
	void makeEntry(std::string name, std::string value);
	//! Gets the value that is associated with the name. Returns an empty string if name was not found.
	std::string getValue(std::string name);

	//! Overwrites the parameter file with new data.
	int write();
	//! Reads and parses the parameter file. Needs to be called before you can get values from an ParamFile object.
	int read();
	//! Prints a list with all defined parameters and their values to stdout.
	void print();
	//! Returns the number of defined parameters.
	int getSize() const;
	//! Clears all defined parameters.
	void clear();

	//! Returns an iterator to the first parameter.
	std::map<std::string,std::string>::iterator getBegin() { return data.begin(); }
	//! Returns an iterator that indicates the end of the parameter list.
	std::map<std::string,std::string>::iterator getEnd() { return data.end(); }

private:
	std::string file;
	std::map <std::string, std::string> data;
	std::map<std::string,std::string>::iterator data_iter;
};
