// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  RelaisBoard.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Stephan Riedel
// Date:      26.04.2008
// *****************************************************************

//#define DEBUG
#include "RelaisBoard.h"

RelaisBoard::RelaisBoard (SerialPort& serial) : m_serial(serial) {

	char buf[4];
	sndCmd(1,1,0);	// initialize card
	rcvCmd();
	getStatus();
}

int RelaisBoard::sndCmd(unsigned char command, unsigned char addr, unsigned char data) {
	
	char buf[4];
	buf[0] = command;
	buf[1] = addr;
	buf[2] = data;
	buf[3] = buf[0]^buf[1]^buf[2];	// calculation of the checksum
	
	#ifdef DEBUG
		printf(" -> sncmd: 0x%02x 0x%02x 0x%02x 0x%02x\n", buf[0], buf[1], buf[2], buf[3]);
	#endif

	if (m_serial.writeData(buf,4) != 4) return -1;
	
	usleep(20000);	// short pause; card misses some messages otherwise
	return rcvCmd();

}


int RelaisBoard::rcvCmd() {

	char buf[4];
	if (m_serial.readData(buf, 4) != 4) return -1;
	
	char checksum = buf[0]^buf[1]^buf[2];

	#ifdef DEBUG
		printf(" -> recv: 0x%02x 0x%02x 0x%02x 0x%02x\n", buf[0], buf[1], buf[2], buf[3]);
	#endif
	
	m_cmd  = buf[0];
	m_addr = buf[1];
	m_data = buf[2];
	if (checksum == buf[3]) return 0;
	else {
		printf("RelaisBoard::rcvCmd(): Checksum wrong!\n");
		return(-1);
	}
}

int RelaisBoard::setRelaisOn(unsigned char data) {
	m_state |= data;
	return sndCmd(3,1,m_state);
}


int RelaisBoard::setRelaisOff(unsigned char data) {
	m_state &= ~data;
	return sndCmd(3,1,m_state);
}

int RelaisBoard::getStatus() {

	if (sndCmd(2,1,0) == 0 && m_cmd == 0xfd) {
		m_state = m_data;
		return m_state & 0x00FF;
	}
	else return -1;
}



