// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  RelaisBoard.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Stephan Riedel
// Date:      26.04.2008
// *****************************************************************

#ifndef _RELAISBOARD_H_
#define _RELAISBOARD_H_

#include "SerialPort.h"

//! Driver class for relais board.
class RelaisBoard {

	public:
		RelaisBoard(SerialPort& serial);
		~RelaisBoard(){}
		int setRelaisOn(unsigned char rel);          //!< switches relais "data" [0-255] on
		int setRelaisOff(unsigned char rel);         //!< switches relais "data" [0-255] off
		int getStatus();                             //!< returns the current relais "data"
	private:
		int sndCmd(unsigned char command, unsigned char addr, unsigned char data); //!< sends the command to the card, checksum is calculatet automatically
		int rcvCmd();                                //!< receives relais status
		SerialPort& m_serial;                        //!< Reference to serial port
		unsigned char m_state;                       //!< relais states [0-255]
		unsigned char m_cmd, m_addr, m_data;         //!< response bytes from card
};

#endif /* _RELAISBOARD_H_ */

