// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  WaitCondition.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Daniel Jagszent
// Date:      21.05.2008
// *****************************************************************

#include "WaitCondition.h"
#include <pthread.h>

WaitCondition::WaitCondition(Mutex& m)
{
	mutex = &(m.mutex);
	pthread_cond_init(&condition, NULL);
}

WaitCondition::~WaitCondition()
{
	pthread_cond_destroy(&condition);
}


void WaitCondition::lock()
{
	pthread_mutex_lock(mutex);
}
void WaitCondition::unlock()
{
	pthread_mutex_unlock(mutex);
}

void WaitCondition::wait()
{
	pthread_cond_wait(&condition, mutex);
}

bool WaitCondition::wait(const timespec * abstime)
{
	if (pthread_cond_timedwait(&condition, mutex, abstime)) {
		return false; // condition not met (possible due to timeout)
	}
	return true; // condition met
}

void WaitCondition::signalOne()
{
	pthread_cond_signal(&condition);
}

void WaitCondition::signalAll()
{
	pthread_cond_broadcast(&condition);
}

