// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  WaitCondition.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder, Daniel Jagszent
// Date:      21.05.2008
// *****************************************************************

#ifndef _WAITCONDITION_H_
#define _WAITCONDITION_H_

#include "Mutex.h"

class timespec; // forward declaration

//! C++-Wrapper for pthread conditions.
class WaitCondition {

public:
	//! The constructor needs a reference to a Mutex object as parameter. The life-time of the Mutex object needs to be as least as long as the lifetime of the WaitCondition.
	WaitCondition(Mutex& m);
	~WaitCondition();

	//! Gets a lock on the connected Mutex.
	void lock();
	//! Releases the connected Mutex.
	void unlock();

	//! Waits for the condition. Precondition: The calling thread needs a lock on the connected Mutex.
	void wait();
	//! Waits for the condition but only until abstime is reached. Returns false if condition was not triggered in the time period. Precondition: The calling thread needs a lock on the connected Mutex.
	bool wait(const timespec * abstime);
	//! Wakes one waiting thread. Precondition: The calling thread needs a lock on the connected Mutex.
	void signalOne();
	//! Wakes all waiting threads. Precondition: The calling thread needs a lock on the connected Mutex.
	void signalAll();

protected:
	pthread_mutex_t* mutex;
	pthread_cond_t condition;
private:
	WaitCondition(const WaitCondition& w); //!< disabled copy-constructor
	void operator=(const WaitCondition&);
};

#endif /* _WAITCONDITION_H_ */
