// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  iowarrior_i2c.h
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      26.04.2008
// *****************************************************************

#ifndef _IOWARRIOR_I2C_H_
#define _IOWARRIOR_I2C_H_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <linux/types.h>
#include "iowarrior.h"

#define USB_VENDOR_ID_CODEMERCS	1984
/* low speed iowarrior */
#define USB_DEVICE_ID_CODEMERCS_IOW40	0x1500
#define USB_DEVICE_ID_CODEMERCS_IOW24	0x1501
#define USB_DEVICE_ID_CODEMERCS_IOWPV1	0x1511
#define USB_DEVICE_ID_CODEMERCS_IOWPV2	0x1512
/* full speed iowarrior */
#define USB_DEVICE_ID_CODEMERCS_IOW56	0x1503

#define MAXDEVICES 10

#ifdef  __cplusplus
extern "C" {
#endif // __cplusplus

//! Prints all information about all found IOWarriors to stdout.
void iow_print_warriors(const char* basename);
//! Returns opened file descriptor for the special device serial having the basename basename.
int iow_find_special_descriptor(const char *serial, const char* basename);
//! Writes I2C message to address through an IOWarrior that is connected with the file descriptor fd.
int iow_i2c_write(char address, char *buf, int size, int report_size, int fd);
//! Reads an I2C message from address in buffer buf with the maximum size size.
int iow_i2c_read(char address, char *buf, int size, int report_size, int fd);
//! Initialize I2C on the IOWarrior connected with file descriptor fd.
int iow_i2c_init(int fd);

#ifdef  __cplusplus
}
#endif // __cplusplus

#endif /* _IOWARRIOR_I2C_H_ */

