#ifndef _V4L_CAPTURE_H_
#define _V4L_CAPTURE_H_


// *****************************************************************
// necessary includes
// *****************************************************************

#include "Interfaces/VideoCaptureInterface.h"
#include <string>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <linux/videodev.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>


// *****************************************************************
// forward declarations
// *****************************************************************

class CByteImage;

// *****************************************************************
// CV4LCapture
// *****************************************************************

class CV4LCapture : public CVideoCaptureInterface
{
public:
	// constructor
	CV4LCapture(std::string devName, int channel, int width = 320, int height = 240);

	// destructor
	~CV4LCapture();


	// public methods
	bool OpenCamera();
	void CloseCamera();
	bool CaptureImage(CByteImage **ppImages);
	
	int GetWidth();
	int GetHeight();
	CByteImage::ImageType GetType();
	int GetNumberOfCameras() { return 1; }


private:
	// private methods
	char* NextFrame();

	// private attributes
	bool m_bOK;

	int m_iWidth, m_iHeight;

	std::string deviceName;
	int deviceHandle;

	struct video_capability capability;
	struct video_channel queryChannel;
	struct video_channel selectedChannel;
	struct video_window captureWindow;
	struct video_picture imageProperties;
	struct video_mbuf memoryBuffer;
	struct video_mmap* mmaps;

	char* memoryMap;
	int channelNumber0;
	int depth;
	int bufferIndex;
};


#endif

