// *****************************************************************
// This file is part of the IVT - Integrating Vision Toolkit.
//
// Copyright (C) 2004-2008 Pedram Azad, Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Pedram Azad, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Pedram Azad
// Date:      29.09.2008
// *****************************************************************

// *****************************************************************
// includes
// *****************************************************************


#include "VFLinuxCapture.h"

#include "Image/ImageProcessor.h"
#include "Image/ByteImage.h"

#include "Interfaces/ApplicationHandlerInterface.h"
#include "Interfaces/MainWindowInterface.h"
#include "gui/GUIFactory.h"


#include <stdio.h>



int main(int argc, char **args)
{	

	CV4LCapture capture("/dev/video0", 0);

	
	// open camera
	if (!capture.OpenCamera())
	{
		printf("error: could not open camera\n");
		return 1;
	}

	
	const int width = capture.GetWidth();
	const int height = capture.GetHeight();
	const int nPixels = width * height;

	CByteImage Image(width, height, CByteImage::eRGB24);
	CByteImage grayImage(width, height, CByteImage::eGrayScale);
	CByteImage lastImage(&grayImage);
	
	CByteImage *pImage = &Image;
	
	// create the application handler
	CApplicationHandlerInterface *pApplicationHandler = CreateApplicationHandler();
	pApplicationHandler->Reset();
	
	// create a window
	CMainWindowInterface *pMainWindow = CreateMainWindow(0, 0, 2*width,height, "Motion Segmentation");
	WIDGET_HANDLE pImageWidget1 = pMainWindow->AddImage(0, 0, width, height);
	WIDGET_HANDLE pImageWidget2 = pMainWindow->AddImage(width, 0, width, height);
	
	pMainWindow->Show();
	
	while (!pApplicationHandler->ProcessEventsAndGetExit())
	{
		capture.CaptureImage(&pImage);
		
		ImageProcessor::ConvertImage(&Image, &grayImage);
		
		// simple motion detection
		ImageProcessor::AbsoluteDifference(&grayImage, &lastImage, &lastImage);
		
		ImageProcessor::ThresholdBinarize(&lastImage, &lastImage, 20);
		
		pMainWindow->SetImage(pImageWidget1, &Image);
		pMainWindow->SetImage(pImageWidget2, &lastImage);
		
		ImageProcessor::CopyImage(&grayImage, &lastImage);
	}
	
	delete pMainWindow;
	delete pApplicationHandler;
	
	return 0;
}
