// *****************************************************************
// This file is part of the IVT - Integrating Vision Toolkit.
//
// Copyright (C) 2004-2008 Pedram Azad, Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Pedram Azad, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Pedram Azad
// Date:      29.09.2008
// *****************************************************************


// *****************************************************************
// includes
// *****************************************************************

#include "Interfaces/MainWindowInterface.h"
#include "Interfaces/ApplicationHandlerInterface.h"
#include "gui/GUIFactory.h"
#include "Image/ByteImage.h"

#include "VFLinuxCapture.h"

#include <stdio.h>


int main(int argc, char **args)
{
	// create capture object
	CV4LCapture capture("/dev/video0", 0);
	
	// open camera
	if (!capture.OpenCamera())
	{
		printf("error: could not open camera\n");
		return 1;
	}
	
	const int width = capture.GetWidth();
	const int height = capture.GetHeight();
	const CByteImage::ImageType type = capture.GetType();
	const int nCameras = capture.GetNumberOfCameras();

	CByteImage **ppImages = new CByteImage*[nCameras];
	for (int i = 0; i < nCameras; i++)
	{
		ppImages[i] = new CByteImage(width, height, type);
	}

	// create the application handler
	CApplicationHandlerInterface *pApplicationHandler = CreateApplicationHandler();
	pApplicationHandler->Reset();
	
	// create the main window
	printf("Creating main window with dimensions: %i %i\n", width, height);
	CMainWindowInterface *pMainWindow = CreateMainWindow(0, 0, width, height + 50, "Capture Application");
	
	// add an image widget to display an image
	WIDGET_HANDLE pImageWidget = pMainWindow->AddImage(0, 0, width, height);
	
	// add a combo box to choose which camera image to display (at most 10 cameras can be used)
	const char *ppEntries[10] = {"Camera 0", "Camera 1", "Camera 2", "Camera 3", "Camera 4", "Camera 5", "Camera 6", "Camera 7", "Camera 8", "Camera 9"};
	WIDGET_HANDLE pComboBox = pMainWindow->AddComboBox(10, height + 10, 150, 30, (nCameras > 10 ? 10 : nCameras), ppEntries, 0);
	
	// make the main window visible
	pMainWindow->Show();
	
	while (!pApplicationHandler->ProcessEventsAndGetExit())
	{
		if (!capture.CaptureImage(ppImages))
			break;
		
		int nSelectedCamera = -1;
		if (pMainWindow->GetValue(pComboBox, nSelectedCamera))
		{
			pMainWindow->SetImage(pImageWidget, ppImages[nSelectedCamera]);
		}
	}
	
	for (int j = 0; j < nCameras; j++)
	{
		delete ppImages[j];
	}
	delete [] ppImages;
	
	delete pMainWindow;
	delete pApplicationHandler;

	return 0;
}
