/*****************************************************************/
/* Dateiname   : ClientConnect5000.c                             */
/* Beschreibung: Client-Programm                                 */
/*               baut eine TCP-Verbindung zu einem Server auf    */
/*               an Port 5000 (Gegenstck zu ServerAccept.c)     */
/*****************************************************************/

#include <sys/socket.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>

int main()
  {
   int socket_nummer;
   int laenge;
   struct sockaddr_in adressinfo;
   int ergebnis;
   unsigned short int portnummer = 5000;
   char ip_adresse[] = "127.0.0.1";

   socket_nummer = socket(AF_INET, SOCK_STREAM, 0);
   adressinfo.sin_family = AF_INET;
   inet_pton(AF_INET,ip_adresse,&adressinfo.sin_addr.s_addr);
   adressinfo.sin_port = htons(portnummer);
   laenge = sizeof(adressinfo);
   printf("\n Client: connect()...");
   ergebnis = connect(socket_nummer, (struct sockaddr *)&adressinfo, laenge);
   if (ergebnis == 0)
     {
      printf("\n Verbindungsaufbau zu IP %s",ip_adresse);
      printf(" - Port %d",portnummer);
      printf("\n Verbindungsaufbau erfolgreich");
     }
   else
     {
      perror("Fehler beim Verbindungsaufbau: ");
     }
   printf("\n Client: close()...");
   close(socket_nummer);
   printf("\n\n");
   return(0);
  }

